<?php
_debug(__FILE__ . ' loaded');

global $dispatcher;
global $plug;

// Exemple n°1
// Appel à la fonction notifyTest()
function notifyTest(sfEvent $event) {
	_debug('[event/dispatcher] - we run ' . __FUNCTION__ . '() function by notify() call.');
	_debug('[event/dispatcher] - object : ' . get_class($event->getSubject()). ' - event name : ' . $event->getName());
}

// Exemple n°2
// Appel à la fonction changingValueTest()
function changingValueTest(sfEvent $event, $data)
{
	$subject = $event->getSubject();
	save_array_to_file(SITE_PATH.'tmp/dump.news.txt',$subject);
	save_array_to_file(SITE_PATH.'tmp/dump2.news.txt',$event['data']);
	_debug('[event/dispatcher] - we run ' . __FUNCTION__ . '() function by filter() call.');
	_debug('[event/dispatcher] - object : ' . get_class($subject). ' - event name : ' . $event->getName());
	$data['2'] = "XXXXXXXXXXXXX modified content XXXXXXXXXXXXX";

	return $data;
}

// Exemple n°3
// Appel à la classe extensibleNews()
class extensibleNews
{
	static public function listenToMethodNotFound(sfEvent $event)
	{

		switch ($event['method'])
		{
			case 'doTest':
				self::doTest($event->getSubject(), $event['arguments']);
				return true;
			default:
				return false;
		}
	}

	static private function doTest($subject, $arguments)
	{
		if(is_string($arguments)) $msg = $arguments;
		if(is_array($arguments))	$msg = join(', ', $arguments);
		_debug('[event/dispatcher] (INTERNAL) - we run ' . __FUNCTION__ . '() function by extensibleFunc() call with arguments : '. $msg);
	}

}

// Exemple n°4
// Log de l'authentification dans [path to app]/tmp
function logAction(sfEvent $event) {
	$a[0]= $event['login']. " s'est authentifé le ".date('d/n/Y à H:i:s')." depuis ". $event['type'];
	logfile(SITE_PATH.'/tmp/log_auth.txt', $a);
}


// Exemple n°1
$dispatcher->connect('news.before_datacheck', 'notifyTest');

// Exemple n°2
$dispatcher->connect('news.after_datacheck', 'changingValueTest');

// Exemple n°3
// Extension de classe avec le système Event/eventDispatcher
$dispatcher->connect('news.extensible_function', array('extensibleNews', 'listenToMethodNotFound'));

// Test conditionnel sur la section 'news'
if(isset($_REQUEST['rub']) && $_REQUEST['rub'] == 'news') {
	include_once '../class/class.news.php';
	$n = new news;
	$n->doTest('arg 1', 'arg 2', 'arg 3');
}

// Exemple n°4
$dispatcher->connect('authentication.main_authentication', 'logAction');

function save_array_to_file($filename,$b)
{
	if (!is_resource($filename))
	{
		if (!$file = fopen($filename,'w+')) return false;
	} else {
		$file = $filename;
	}
	foreach ($b as $key=>$val)
	{
		fwrite($file,(is_int($key) ? chr(6).(string)$key : chr(5).$key));
		if (is_array($val))
		{
			fwrite($file,chr(0)); //array starts
			save_array_to_file($file,$val);
			fwrite($file,chr(1)); //array ends
		}
		elseif (is_int($val))
		{
			fwrite($file,chr(2).(string) $val); //int
		}
		elseif (is_string($val))
		{
			fwrite($file,chr(3).$val); //string
		}
	}
	if (!is_resource($filename)) fclose($file);
	return true;
}

?>